/*
 * Decompiled with CFR 0.152.
 */
package com.blogspot.radialmind.html;

import com.blogspot.radialmind.html.Attribute;
import com.blogspot.radialmind.html.IHTMLFilter;
import com.blogspot.radialmind.html.IHTMLVisitor;
import com.blogspot.radialmind.html.Node;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TagNode
extends Node
implements IHTMLVisitor {
    private String name;
    private List<Attribute> attributes = new ArrayList<Attribute>();
    private List<Node> childNodes = new ArrayList<Node>();
    private static final Set IMMEDIATE_CLOSE_TAGS = new HashSet();

    public TagNode(String name) {
        this.name = name;
    }

    public void addAttribute(String name, String value) {
        this.attributes.add(new Attribute(name, value));
    }

    public void addNode(Node node) {
        this.childNodes.add(node);
        node.setPrevNode(this);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void writeAll(Writer writer, IHTMLFilter filter, boolean convertIntoValidXML, boolean filterText) throws IOException {
        boolean filterAttribute = false;
        boolean filterTag = false;
        String attrValue = null;
        if (filter != null) {
            filterTag = filter.filterTag(this.name);
        }
        if (!filterTag) {
            writer.append("<");
            writer.append(this.name);
            for (Attribute attribute : this.attributes) {
                attrValue = attribute.getValue();
                if (filter != null) {
                    filterAttribute = filter.filterAttribute(this.name, attribute.getName(), attribute.getValue());
                    attrValue = filter.modifyAttributeValue(this.name, attribute.getName(), attribute.getValue());
                }
                if (filterAttribute) continue;
                this.writeAttributeValue(writer, attribute, attrValue);
            }
            if (this.shouldBeClosedImmediately() && convertIntoValidXML) {
                writer.append("/>");
            } else {
                writer.append(">");
            }
        } else {
            filterText = true;
        }
        for (Node node : this.childNodes) {
            node.writeAll(writer, filter, convertIntoValidXML, filterText);
        }
        if (!filterTag && !this.shouldBeClosedImmediately()) {
            writer.append("</");
            writer.append(this.name);
            writer.append(">");
        }
    }

    boolean shouldBeClosedImmediately() {
        return IMMEDIATE_CLOSE_TAGS.contains(this.name);
    }

    boolean mayContainOtherTags() {
        return !IMMEDIATE_CLOSE_TAGS.contains(this.name);
    }

    private void writeAttributeValue(Writer writer, Attribute a, String attrValue) throws IOException {
        writer.append(" ");
        writer.append(a.getName());
        char sep = this.getAttributeSeparator(attrValue);
        if (attrValue != null && attrValue.length() > 0) {
            writer.append("=");
            writer.append(sep);
            writer.append(attrValue);
            writer.append(sep);
        }
    }

    private char getAttributeSeparator(String attrValue) {
        if (!attrValue.contains("\"")) {
            return '\"';
        }
        if (!attrValue.contains("'")) {
            return '\'';
        }
        if (!attrValue.contains("`")) {
            return '`';
        }
        return '\"';
    }

    static {
        IMMEDIATE_CLOSE_TAGS.add("br");
        IMMEDIATE_CLOSE_TAGS.add("hr");
        IMMEDIATE_CLOSE_TAGS.add("input");
        IMMEDIATE_CLOSE_TAGS.add("img");
    }
}

