/*
 * Decompiled with CFR 0.152.
 */
package com.blogspot.radialmind.html;

import com.blogspot.radialmind.html.HandlingException;
import com.blogspot.radialmind.html.IHTMLFilter;
import com.blogspot.radialmind.html.Node;
import com.blogspot.radialmind.html.TagNode;
import com.blogspot.radialmind.html.TextNode;
import com.blogspot.radialmind.html.htmlLexerLexer;
import com.blogspot.radialmind.html.htmlParserParser;
import com.blogspot.radialmind.html.htmlTreeParser;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeNodeStream;

public class HTMLParser {
    private static ThreadLocal topNode;
    private static ThreadLocal currentNode;
    private static ThreadLocal attrNode;

    public static void process(Reader reader, Writer writer, IHTMLFilter htmlFilter, boolean convertIntoValidXML) throws HandlingException {
        try {
            ANTLRReaderStream input = new ANTLRReaderStream(reader);
            htmlLexerLexer lex = new htmlLexerLexer((CharStream)input);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
            htmlParserParser parser = new htmlParserParser((TokenStream)tokens);
            htmlParserParser.document_return root = parser.document();
            CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)((Tree)root.getTree()));
            htmlTreeParser walker = new htmlTreeParser((TreeNodeStream)nodes);
            topNode = new ThreadLocal();
            currentNode = new ThreadLocal();
            attrNode = new ThreadLocal();
            walker.document();
            TagNode top = (TagNode)topNode.get();
            top.writeAll(writer, htmlFilter, convertIntoValidXML, false);
        }
        catch (IOException ioe) {
            throw new HandlingException("Could not parse document");
        }
        catch (RecognitionException re) {
            throw new HandlingException("Could not parse document");
        }
    }

    static void openTag(String tagName) throws IOException {
        TagNode node = (TagNode)topNode.get();
        if (node == null) {
            node = new TagNode(tagName.toLowerCase());
            topNode.set(node);
            currentNode.set(node);
        } else {
            TagNode curNode = (TagNode)currentNode.get();
            node = new TagNode(tagName.toLowerCase());
            curNode.addNode(node);
            if (node.mayContainOtherTags()) {
                currentNode.set(node);
            }
        }
        attrNode.set(node);
    }

    static void addAttribute(String attributeName, String value) throws IOException {
        TagNode curNode = (TagNode)attrNode.get();
        if ((value = value.trim()).length() > 1) {
            if (value.startsWith("=\"") || value.startsWith("='") || value.startsWith("=`")) {
                value = value.substring(2);
                value = value.substring(0, value.length() - 1);
            } else {
                value = value.substring(1);
            }
        }
        curNode.addAttribute(attributeName.toLowerCase(), value);
    }

    static void finishAttributes() throws IOException {
        Node node = (Node)attrNode.get();
        attrNode.set(node.getPrevNode());
    }

    static void addText(String text) throws IOException {
        if (text == null) {
            return;
        }
        if (text.trim().equals("")) {
            return;
        }
        TagNode curNode = (TagNode)currentNode.get();
        if (curNode.getName().equals("body")) {
            TagNode p = new TagNode("p");
            p.addNode(new TextNode("p", text));
            curNode.addNode(p);
        } else {
            curNode.addNode(new TextNode(curNode.getName(), text));
        }
    }

    static void closeTag(String tagName) throws IOException {
        TagNode curNode = (TagNode)currentNode.get();
        TagNode tempNode = new TagNode(tagName);
        if (tempNode.mayContainOtherTags()) {
            while (!curNode.getName().equals(tagName.toLowerCase())) {
                curNode = (TagNode)curNode.getPrevNode();
            }
            currentNode.set(curNode.getPrevNode());
        }
    }
}

