/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.reedsolomon;

import jp.sourceforge.reedsolomon.Galois;

public class RsDecode {
    public static final int RS_PERM_ERROR = -1;
    public static final int RS_CORRECT_ERROR = -2;
    private static final Galois galois = Galois.getInstance();
    private int npar;

    public RsDecode(int npar) {
        this.npar = npar;
    }

    public int calcSigmaMBM(int[] sigma, int[] omega, int[] syn) {
        int[] sg0 = new int[this.npar];
        int[] sg1 = new int[this.npar];
        sg0[1] = 1;
        sg1[0] = 1;
        int jisu0 = 1;
        int jisu1 = 0;
        int m = -1;
        int n = 0;
        while (n < this.npar) {
            int d = syn[n];
            int i = 1;
            while (i <= jisu1) {
                d ^= galois.mul(sg1[i], syn[n - i]);
                ++i;
            }
            if (d != 0) {
                int logd = galois.toLog(d);
                int[] wk = new int[this.npar];
                int i2 = 0;
                while (i2 <= n) {
                    wk[i2] = sg1[i2] ^ galois.mulExp(sg0[i2], logd);
                    ++i2;
                }
                int js = n - m;
                if (js > jisu1) {
                    m = n - jisu1;
                    jisu1 = js;
                    if (jisu1 > this.npar / 2) {
                        return -1;
                    }
                    int i3 = 0;
                    while (i3 <= jisu0) {
                        sg0[i3] = galois.divExp(sg1[i3], logd);
                        ++i3;
                    }
                    jisu0 = jisu1;
                }
                sg1 = wk;
            }
            System.arraycopy(sg0, 0, sg0, 1, Math.min(sg0.length - 1, jisu0));
            sg0[0] = 0;
            ++jisu0;
            ++n;
        }
        galois.mulPoly(omega, sg1, syn);
        System.arraycopy(sg1, 0, sigma, 0, Math.min(sg1.length, sigma.length));
        return jisu1;
    }

    private int chienSearch(int[] pos, int n, int jisu, int[] sigma) {
        int last = sigma[1];
        if (jisu == 1) {
            if (galois.toLog(last) >= n) {
                return -2;
            }
            pos[0] = last;
            return 0;
        }
        int posIdx = jisu - 1;
        int i = 0;
        while (i < n) {
            int z = 255 - i;
            int wk = 1;
            int j = 1;
            while (j <= jisu) {
                wk ^= galois.mulExp(sigma[j], z * j % 255);
                ++j;
            }
            if (wk == 0) {
                int pv = galois.toExp(i);
                last ^= pv;
                pos[posIdx--] = pv;
                if (posIdx == 0) {
                    if (galois.toLog(last) >= n) {
                        return -2;
                    }
                    pos[0] = last;
                    return 0;
                }
            }
            ++i;
        }
        return -2;
    }

    private void doForney(int[] data, int length, int jisu, int[] pos, int[] sigma, int[] omega) {
        int i = 0;
        while (i < jisu) {
            int ps = pos[i];
            int zlog = 255 - galois.toLog(ps);
            int ov = omega[0];
            int j = 1;
            while (j < jisu) {
                ov ^= galois.mulExp(omega[j], zlog * j % 255);
                ++j;
            }
            int dv = sigma[1];
            int j2 = 2;
            while (j2 < jisu) {
                dv ^= galois.mulExp(sigma[j2 + 1], zlog * j2 % 255);
                j2 += 2;
            }
            int n = galois.toPos(length, ps);
            data[n] = data[n] ^ galois.mul(ps, galois.div(ov, dv));
            ++i;
        }
    }

    public int decode(int[] data, int length, boolean noCorrect) {
        if (length < this.npar || length > 255) {
            return -1;
        }
        int[] syn = new int[this.npar];
        if (galois.calcSyndrome(data, length, syn)) {
            return 0;
        }
        int[] sigma = new int[this.npar / 2 + 2];
        int[] omega = new int[this.npar / 2 + 1];
        int jisu = this.calcSigmaMBM(sigma, omega, syn);
        if (jisu <= 0) {
            return -2;
        }
        int[] pos = new int[jisu];
        int r = this.chienSearch(pos, length, jisu, sigma);
        if (r < 0) {
            return r;
        }
        if (!noCorrect) {
            this.doForney(data, length, jisu, pos, sigma, omega);
        }
        return jisu;
    }

    public int decode(int[] data, int length) {
        return this.decode(data, length, false);
    }

    public int decode(int[] data) {
        return this.decode(data, data.length, false);
    }
}

