/*
 * Decompiled with CFR 0.152.
 */
package com.blogspot.radialmind.xss;

import com.blogspot.radialmind.html.IHTMLFilter;
import java.util.HashSet;
import java.util.Set;

public class XSSFilter
implements IHTMLFilter {
    private static final Set<String> FORBIDDEN_TAGS = new HashSet<String>();

    @Override
    public boolean filterAttribute(String tagName, String attrName, String attrValue) {
        if (attrName.toLowerCase().startsWith("on")) {
            return true;
        }
        return this.isScriptedAttributeValue(attrValue);
    }

    @Override
    public boolean filterTag(String tagName) {
        return FORBIDDEN_TAGS.contains(tagName);
    }

    @Override
    public String modifyAttributeValue(String tagName, String attrName, String attrValue) {
        return attrValue;
    }

    @Override
    public String modifyNodeText(String tagName, String text) {
        return text;
    }

    private boolean isScriptedAttributeValue(String attrValue) {
        attrValue = this.decode(attrValue);
        if ((attrValue = attrValue.trim().toLowerCase()).contains("javascript:")) {
            return true;
        }
        if (attrValue.contains("mocha:")) {
            return true;
        }
        if (attrValue.contains("eval")) {
            return true;
        }
        if (attrValue.contains("vbscript:")) {
            return true;
        }
        if (attrValue.contains("livescript:")) {
            return true;
        }
        if (attrValue.contains("expression(")) {
            return true;
        }
        if (attrValue.contains("url(")) {
            return true;
        }
        if (attrValue.contains("&{")) {
            return true;
        }
        return attrValue.contains("&#");
    }

    private String decode(String value) {
        value = value.replace("\u0000", "");
        value = value.replace("\u0001", "");
        value = value.replace("\u0002", "");
        value = value.replace("\u0003", "");
        value = value.replace("\u0004", "");
        value = value.replace("\u0005", "");
        value = value.replace("\u0006", "");
        value = value.replace("\u0007", "");
        value = value.replace("\b", "");
        value = value.replace("\t", "");
        value = value.replace("\n", "");
        value = value.replace("\u000b", "");
        value = value.replace("\f", "");
        value = value.replace("\r", "");
        value = value.replace("\u000e", "");
        value = value.replace("\u000f", "");
        value = value.replace("\u0010", "");
        value = value.replace("\u0011", "");
        value = value.replace("\u0012", "");
        value = value.replace("\u0013", "");
        value = value.replace("\u0014", "");
        value = value.replace("\u0015", "");
        value = value.replace("\u0016", "");
        value = value.replace("\u0017", "");
        value = value.replace("\u0018", "");
        value = value.replace("\u0019", "");
        value = value.replace("\u001a", "");
        value = value.replace("\u001b", "");
        value = value.replace("\u001c", "");
        value = value.replace("\u001d", "");
        value = value.replace("\u001e", "");
        value = value.replace("\u001f", "");
        return value;
    }

    static {
        FORBIDDEN_TAGS.add("script");
        FORBIDDEN_TAGS.add("embed");
        FORBIDDEN_TAGS.add("object");
        FORBIDDEN_TAGS.add("layer");
        FORBIDDEN_TAGS.add("style");
        FORBIDDEN_TAGS.add("meta");
        FORBIDDEN_TAGS.add("iframe");
        FORBIDDEN_TAGS.add("frame");
        FORBIDDEN_TAGS.add("link");
        FORBIDDEN_TAGS.add("import");
        FORBIDDEN_TAGS.add("xml");
    }
}

